package cn.com.duiba.sign.center.api.dto;



import cn.com.duiba.sign.center.api.enums.creditssign.ActivityTimeValidityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.CustomCircleTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * Created by xiaoxuda on 2017/6/1.
 */
public class SignRuleConfigDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = 948952194538419135L;

    /**
     * 签到规则在json配置中的key
     */
    public static final String KEY_TYPE = "type";
    public static final String KEY_VALIDITY_TYPE = "acValidityType";
    public static final String KEY_CUSTOM_CIRCLE_START = "cusCirStart";
    public static final String KEY_CUSTOM_CIRCLE_TYPE = "cusCirType";
    public static final String KEY_CUSTOM_CIRCLE_DAYS = "cusCirDays";
    @Deprecated
    public static final String KEY_ITEMS = "items";

    /**
     * 签到周期类型
     */
    private SignTypeEnum type;

    /**
     * 抽奖次数有效期类型
     */
    private ActivityTimeValidityTypeEnum acValidityType;
    /**
     * 自定义周期起始时间
     */
    private Date cusCirStart;
    /**
     * 自定义周期类型
     */
    private CustomCircleTypeEnum cusCirType;
    /**
     * 周期天数,周期签到及固定时间自定义周期签到时有效
     */
    private Integer cusCirDays;

    public SignTypeEnum getType() {
        return type;
    }

    public void setType(SignTypeEnum type) {
        this.type = type;
    }

    public ActivityTimeValidityTypeEnum getAcValidityType() {
        return acValidityType;
    }

    public void setAcValidityType(ActivityTimeValidityTypeEnum acValidityType) {
        this.acValidityType = acValidityType;
    }

    public Date getCusCirStart() {
        return cusCirStart;
    }

    public void setCusCirStart(Date cusCirStart) {
        this.cusCirStart = cusCirStart;
    }

    public CustomCircleTypeEnum getCusCirType() {
        return cusCirType == null ? CustomCircleTypeEnum.FIXED_DAYS : cusCirType;
    }

    public void setCusCirType(CustomCircleTypeEnum cusCirType) {
        this.cusCirType = cusCirType;
    }

    public Integer getCusCirDays() {
        return cusCirDays;
    }

    public void setCusCirDays(Integer cusCirDays) {
        this.cusCirDays = cusCirDays;
    }
}
