package cn.com.duiba.sign.center.api.enums.signtreasure;

/**
 * @Author chenxiangge
 * @Date 2019/4/28
 */
public enum SignTreasureAwardStyleEnum {
    EVERYDAY(0, " 每日签到一个"),
    CONSECUTIVE_DAYS(1, "获得连签天数数量")
    ;

    private Integer code;
    private String desc;

    SignTreasureAwardStyleEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignTreasureAwardStyleEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SignTreasureAwardStyleEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
