package cn.com.duiba.sign.center.api.enums.signtreasure;

import com.google.common.collect.Maps;
import java.util.Map;

/**
 * Created by Liugq on 2019/5/5.
 * 夺宝码来源
 */
public enum TreasureOriginEnum {
    TREASURE_ORIGIN_SIGN(0, "签到"),
    TREASURE_ORIGIN_CREDITS(1, "积分兑换"),
    ;

    private static Map<Integer, TreasureOriginEnum> enumMap = Maps.newHashMap();

    static {
        for (TreasureOriginEnum typeEnum : TreasureOriginEnum.values()) {
            enumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    TreasureOriginEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static TreasureOriginEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!enumMap.containsKey(code)){
            return null;
        }
        return enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
