package cn.com.duiba.sign.center.api.dto;


import cn.com.duiba.sign.center.api.enums.creditssign.SignSourceTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 签到统计信息
 * Created by xiaoxuda on 2017/5/31.
 */
public class SignStaticsDto extends BaseDto implements Serializable {
    private static final long serialVersionUID = -8195700036145168564L;

    private Long id;
    /**
     * appId
     */
    private Long appId;
    /**
     * 用户ID
     */
    private Long consumerId;
    /**
     * 签到数据来源
     */
    private SignSourceTypeEnum sourceType;
    /**
     * 签到来源关联ID
     */
    private Long sourceRelationId;
    /**
     * 连续签到天数
     */
    private Integer continueDay;
    /**
     * 累积签到天数（包含补签）
     */
    private Integer acmDay;
    /**
     * 最后签到时间
     */
    private Date lastSignDay;
    private Date gmtCreate;
    private Date gmtModified;

    /**
     * 周期内最大连续签到天数
     * @return
     */
    private Integer maxContinueDay;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public SignSourceTypeEnum getSourceType() {
        return sourceType;
    }

    public void setSourceType(SignSourceTypeEnum sourceType) {
        this.sourceType = sourceType;
    }

    public Long getSourceRelationId() {
        return sourceRelationId;
    }

    public void setSourceRelationId(Long sourceRelationId) {
        this.sourceRelationId = sourceRelationId;
    }

    public Integer getContinueDay() {
        return continueDay;
    }

    public void setContinueDay(Integer continueDay) {
        this.continueDay = continueDay;
    }

    public Integer getAcmDay() {
        return acmDay;
    }

    public void setAcmDay(Integer acmDay) {
        this.acmDay = acmDay;
    }

    public Date getLastSignDay() {
        return lastSignDay;
    }

    public void setLastSignDay(Date lastSignDay) {
        this.lastSignDay = lastSignDay;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    public Integer getMaxContinueDay() {
        return maxContinueDay;
    }

    public void setMaxContinueDay(Integer maxContinueDay) {
        this.maxContinueDay = maxContinueDay;
    }
}
