package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/5/15
 * @description: 状态奖励条件
 */
public enum EffectiveConditionEnum {
    EFFECTIVE_CONDITION_NULL(0,"无条件"),
    EFFECTIVE_CONDITION_FULL(1,"吃饱"),
    EFFECTIVE_CONDITION_HUNGRY(2,"未吃饱")
    ;
    private String desc;
    private int code;

    EffectiveConditionEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer,EffectiveConditionEnum> typeMap = new HashMap<>();
    static{
        for(EffectiveConditionEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static EffectiveConditionEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的喂养状态，status="+code);
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
