package cn.com.duiba.sign.center.api.enums.signtreasure;

import com.google.common.collect.Maps;
import java.util.Map;

/**
 * Created by Liugq on 2019/5/5.
 * 领奖状态状态
 */
public enum RewardStatusEnum {
    REWARD_STATUS_FAIL(0,"未中奖"),
    REWARD_STATUS_WAIT_OPEN(1, "待开奖"),
    REWARD_STATUS_WATI_GET(2, "待领奖"),
    REWARD_STATUS_FINISH(3, "已领奖"),
    ;

    private static Map<Integer, RewardStatusEnum> enumMap = Maps.newHashMap();

    static {
        for (RewardStatusEnum typeEnum : RewardStatusEnum.values()) {
            enumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    RewardStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static RewardStatusEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!enumMap.containsKey(code)){
            return null;
        }
        return enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
