package cn.com.duiba.sign.center.api.enums.signtreasure;

/**
 * @Author chenxiangge
 * @Date 2019/4/28
 */
public enum SignTreasureStockWarnTypeEnum {
    EMAIL(0, "邮箱"),
    TEL(1, "手机")
    ;

    private Integer code;
    private String desc;

    SignTreasureStockWarnTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static SignTreasureStockWarnTypeEnum getByCode(Integer code) {
        if (code == null) {
            return null;
        }
        for (SignTreasureStockWarnTypeEnum type : values()) {
            if (type.getCode().equals(code)) {
                return type;
            }
        }
        return null;
    }

    public String getDesc() {
        return desc;
    }

    public Integer getCode() {
        return code;
    }
}
