/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.util;

import cn.com.duiba.boot.exception.BizException;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import org.apache.commons.collections.CollectionUtils;

public class GenPokerUtil {
    private static final int SPADE = 1;
    private static final int CLUB = 2;
    private static final int HEART = 3;
    private static final int DIAMOND = 4;
    private static final ImmutableSet<Integer> POKER;

    private GenPokerUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static Integer getRandomFromFull() {
        Random random = new Random();
        return (Integer)POKER.asList().get(random.nextInt(52));
    }

    public static Integer getRandomCardExpectInput(Integer card) {
        if (null == card) {
            return null;
        }
        Integer result = GenPokerUtil.getRandomFromFull();
        while (result.equals(card)) {
            result = GenPokerUtil.getRandomFromFull();
        }
        return result;
    }

    public static List<Integer> getRandomCards(int cardCount) {
        ArrayList<Integer> cards = new ArrayList<Integer>();
        if (cardCount <= 0) {
            return cards;
        }
        for (int i = 0; i < cardCount; ++i) {
            cards.add(GenPokerUtil.getRandomFromFull());
        }
        return cards;
    }

    public static List<String> generateMatchCards(List<Integer> matchCards, int matchCardCount, int cardCount, int deckCount) throws BizException {
        if (matchCardCount > matchCards.size()) {
            throw new BizException("\u9700\u8981\u7b26\u5408\u724c\u6570\u91cf\u5927\u4e8e\u5f53\u524d\u724c\u7ec4\u6570\u91cf");
        }
        if (matchCardCount < 0 || CollectionUtils.isEmpty(matchCards)) {
            throw new BizException("\u9700\u8981\u7b26\u5408\u724c\u6570\u91cf\u6216\u9700\u7b26\u5408\u6570\u91cf\u4e3a\u7a7a");
        }
        if (deckCount <= 0) {
            throw new BizException("\u751f\u6210\u724c\u7ec4\u6570\u91cf<=0");
        }
        StringBuilder prefix = new StringBuilder();
        for (int i = 0; i < matchCardCount - 1; ++i) {
            prefix.append(matchCards.get(i)).append("_");
        }
        ArrayList<String> resultDeck = new ArrayList<String>();
        for (int j = 0; j < deckCount; ++j) {
            StringBuilder result = prefix;
            for (int i = matchCardCount; i < cardCount - 1; ++i) {
                result.append(GenPokerUtil.getRandomCardExpectInput(matchCards.get(i)));
            }
            resultDeck.add(result.toString());
        }
        return resultDeck;
    }

    static {
        ArrayList list = Lists.newArrayList();
        for (int i = 1; i < 14; ++i) {
            list.add(i * 10 + 1);
            list.add(i * 10 + 2);
            list.add(i * 10 + 3);
            list.add(i * 10 + 4);
        }
        POKER = ImmutableSet.copyOf((Collection)list);
    }
}

