/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sign.center.api.util;

import cn.com.duiba.activity.common.center.api.enums.share.ShareRelTypeEnum;
import cn.com.duiba.api.enums.ActivityUniformityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignActivityTypeEnum;
import cn.com.duiba.sign.center.api.enums.creditssign.SignSourceTypeEnum;
import java.util.HashMap;
import java.util.Map;

public class SignActTypeUtil {
    private static Map<SignSourceTypeEnum, SignActivityTypeEnum> sourceToActType = new HashMap<SignSourceTypeEnum, SignActivityTypeEnum>();
    private static Map<SignActivityTypeEnum, SignSourceTypeEnum> actTypeToSource = new HashMap<SignActivityTypeEnum, SignSourceTypeEnum>();
    private static Map<SignActivityTypeEnum, ActivityUniformityTypeEnum> actTypeToUniform = new HashMap<SignActivityTypeEnum, ActivityUniformityTypeEnum>();
    private static Map<ShareRelTypeEnum, SignActivityTypeEnum> ShareActTypeToActType = new HashMap<ShareRelTypeEnum, SignActivityTypeEnum>();

    public static SignActivityTypeEnum getSignActType(SignSourceTypeEnum sourceType) {
        return sourceToActType.get((Object)sourceType);
    }

    public static SignSourceTypeEnum getSignSource(SignActivityTypeEnum signType) {
        return actTypeToSource.get((Object)signType);
    }

    public static ActivityUniformityTypeEnum getUniActType(SignActivityTypeEnum signType) {
        return actTypeToUniform.get((Object)signType);
    }

    public static SignActivityTypeEnum getSignActTypeByShareTypeEnum(ShareRelTypeEnum shareRelTypeEnum) {
        return ShareActTypeToActType.get(shareRelTypeEnum);
    }

    static {
        sourceToActType.put(SignSourceTypeEnum.SIGN_SYSTEM, SignActivityTypeEnum.SIGN_CALENDAR);
        sourceToActType.put(SignSourceTypeEnum.SIGN_FOR_NEW, SignActivityTypeEnum.SIGN_FOR_NEW);
        ShareActTypeToActType.put(ShareRelTypeEnum.SIGN_FOR_NEW, SignActivityTypeEnum.SIGN_FOR_NEW);
        for (Map.Entry<SignSourceTypeEnum, SignActivityTypeEnum> entry : sourceToActType.entrySet()) {
            actTypeToSource.put(entry.getValue(), entry.getKey());
        }
        actTypeToUniform.put(SignActivityTypeEnum.SIGN_CALENDAR, ActivityUniformityTypeEnum.CalendarSign);
        actTypeToUniform.put(SignActivityTypeEnum.SIGN_CONTRACT, ActivityUniformityTypeEnum.ContractSign);
        actTypeToUniform.put(SignActivityTypeEnum.SIGN_FOR_NEW, ActivityUniformityTypeEnum.SignForNew);
    }
}

