package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;

import java.io.Serializable;

/**
 * Created by fangdong on 2018/6/12
 */
public class ConsumerSignInfoDto implements Serializable {

    private static final long serialVersionUID = -1589131183349053877L;

    /**
     * 是否可以签到
     */
    private Boolean canSign;
    /**
     * 签到类型
     */
    private SignTypeEnum signType;
    /**
     * 本次签到可以添加的分数(自定义签到不返回此字段)
     */
    private Integer credits = 0;
    /**
     * 下次签到的积分(自定义签到不返回此字段)
     */
    private Integer nextCredits = 0;
    /**
     * 当前连续签到的天数
     */
    private Integer signDay;
    /**
     * 签到周期
     */
    private Integer signCycle;
    /**
     * 签到系统的配置是否完整,没有完整即为false
     */
    private Boolean configError = false;

    public Boolean getConfigError() {
        return configError;
    }

    public void setConfigError(Boolean configError) {
        this.configError = configError;
    }

    public Integer getNextCredits() {
        return nextCredits;
    }

    public void setNextCredits(Integer nextCredits) {
        this.nextCredits = nextCredits;
    }

    public Boolean getCanSign() {
        return canSign;
    }

    public void setCanSign(Boolean canSign) {
        this.canSign = canSign;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public Integer getCredits() {
        return credits;
    }

    public void setCredits(Integer credits) {
        this.credits = credits;
    }

    public Integer getSignDay() {
        return signDay;
    }

    public void setSignDay(Integer signDay) {
        this.signDay = signDay;
    }

    public Integer getSignCycle() {
        return signCycle;
    }

    public void setSignCycle(Integer signCycle) {
        this.signCycle = signCycle;
    }

    @Override
    public String toString() {
        return "ConsumerSignInfoDto{" +
                "canSign=" + canSign +
                ", signType=" + signType +
                ", credits=" + credits +
                ", nextCredits=" + nextCredits +
                ", signDay=" + signDay +
                ", signCycle=" + signCycle +
                ", configError=" + configError +
                '}';
    }
}
