package cn.com.duiba.sign.center.api.enums.signpet;

import cn.com.duiba.sign.center.api.exception.SignCenterException;

import java.util.HashMap;
import java.util.Map;

/**
 * @author liugq
 * @date created in 2018/4/25
 * @description: 宠物状态枚举
 */
public enum SignPetStatusEnum {

    SIGN_PET_STATUS_NORMAL(1,"正常状态"),
    SIGN_PET_STATUS_TRAVEL(2,"外出状态"),
    SIGN_PET_STATUS_EATING(3,"吃饭状态"),
    SIGN_PET_STATUS_STUDY(4,"学习状态"),
    SIGN_PET_STATUS_DRINK(5,"喝水状态"),
    SIGN_PET_STATUS_FREEZE(6,"冻结（睡觉）"),

    SIGN_PET_STATUS_DAYREWARD(99,"屈臣氏订制状态"),
    ;
    private String desc;
    private int code;

    private static Map<Integer,SignPetStatusEnum> typeMap = new HashMap<>();
    static{
        for(SignPetStatusEnum typeEnum:values()){
            typeMap.put(typeEnum.getCode(),typeEnum);
        }
    }

    /**
     * 根据code获取类型，获取失败则抛出异常
     * @param code
     * @return
     */
    public static SignPetStatusEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!typeMap.containsKey(code)){
            throw new SignCenterException("不支持的宠物状态，status="+code);
        }
        return typeMap.get(code);
    }

    SignPetStatusEnum(int code,String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
