package cn.com.duiba.sign.center.api.enums.signtreasure;

import com.google.common.collect.Maps;
import java.util.Map;

/**
 * Created by Liugq on 2019/5/5.
 * 交易状态
 */
public enum ExchangeStatusEnum {
    EXCHANGE_STATUS_WAIT(0, "处理中"),
    EXCHANGE_STATUS_SUC(1, "成功"),
    EXCHANGE_STATUS_FAIL(2, "失败"),
    ;

    private static Map<Integer, ExchangeStatusEnum> enumMap = Maps.newHashMap();

    static {
        for (ExchangeStatusEnum typeEnum : ExchangeStatusEnum.values()) {
            enumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    ExchangeStatusEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ExchangeStatusEnum getEnumByCode(Integer code){
        if(code == null ){
            return null;
        }
        if(!enumMap.containsKey(code)){
            return null;
        }
        return enumMap.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

}
