package cn.com.duiba.sign.center.api.params;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.CheckForNull;
import java.io.Serializable;
import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-08-22.
 */
public class SignComponentActivityExtraParam implements Serializable {

    private static final long serialVersionUID = -2762116593331220153L;

    // 签到周期配置
    private SignComponentCycleConfigParam cycleConfig;
    // 补签配置
    private SignComponentSupplementaryConfigParam supplementConfig;
    // 运营位配置
    private List<SignComponentAdPositionConfigParam> adPositionConfig;

    // -----------------签到配置---------------------------
    // 签到奖励配置
    private SignComponentRewardConfigParam rewardConfig;
    // 抽奖工具配置
    private SignComponentToolsConfigParam toolsConfig;
    // 奖品列表
    private List<SignComponentPrizeParam> prizes;
    // -----------------界面配置---------------------------
    // 界面配置
    private String dataJson;

    public SignComponentCycleConfigParam getCycleConfig() {
        return cycleConfig;
    }

    public void setCycleConfig(SignComponentCycleConfigParam cycleConfig) {
        this.cycleConfig = cycleConfig;
    }

    public SignComponentSupplementaryConfigParam getSupplementConfig() {
        return supplementConfig;
    }

    public void setSupplementConfig(SignComponentSupplementaryConfigParam supplementConfig) {
        this.supplementConfig = supplementConfig;
    }

    public List<SignComponentAdPositionConfigParam> getAdPositionConfig() {
        return adPositionConfig;
    }

    public void setAdPositionConfig(List<SignComponentAdPositionConfigParam> adPositionConfig) {
        this.adPositionConfig = adPositionConfig;
    }

    public SignComponentRewardConfigParam getRewardConfig() {
        return rewardConfig;
    }

    public void setRewardConfig(SignComponentRewardConfigParam rewardConfig) {
        this.rewardConfig = rewardConfig;
    }

    public SignComponentToolsConfigParam getToolsConfig() {
        return toolsConfig;
    }

    public void setToolsConfig(SignComponentToolsConfigParam toolsConfig) {
        this.toolsConfig = toolsConfig;
    }

    public List<SignComponentPrizeParam> getPrizes() {
        return prizes;
    }

    public void setPrizes(List<SignComponentPrizeParam> prizes) {
        this.prizes = prizes;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public String serialize2String() {
        return JSONObject.toJSONString(this);
    }

    @CheckForNull
    public static SignComponentActivityExtraParam deserialize2Object(String json) {
        if (StringUtils.isBlank(json)) {
            return null;
        }
        return JSONObject.parseObject(json, SignComponentActivityExtraParam.class);
    }

}
