package cn.com.duiba.sign.center.api.params;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import javax.annotation.CheckForNull;
import java.io.Serializable;
import java.util.List;

/**
 * Created by 歪大哥😁 on 2019-08-22.
 */
public class SignComponentActivityExtraParam implements Serializable {

    private static final long serialVersionUID = -2762116593331220153L;

    public static final String CYCLE_CONFIG = "cc";
    public static final String SUPPLEMENT_CONFIG = "sc";
    public static final String AD_POSITION_CONFIG = "apc";
    public static final String REWARD_CONFIG = "rc";
    public static final String TOOLS_CONFIG = "tc";
    public static final String DATA_JSON = "dj";
    public static final String PUBLISH = "pub";

    // 签到周期配置
    private SignComponentCycleConfigParam cycleConfig;
    // 补签配置
    private SignComponentSupplementaryConfigParam supplementConfig;
    // 运营位配置
    private List<SignComponentAdPositionConfigParam> adPositionConfig;

    // -----------------签到配置---------------------------
    // 签到奖励配置
    private SignComponentRewardConfigParam rewardConfig;
    // 抽奖工具配置
    private SignComponentToolsConfigParam toolsConfig;
    // -----------------界面配置---------------------------
    // 界面配置
    private String dataJson;
    // 活动是否发布 只要活动曾经发布过 此字段就是true
    private boolean publish;

    public boolean isPublish() {
        return publish;
    }

    public void setPublish(boolean publish) {
        this.publish = publish;
    }

    public SignComponentCycleConfigParam getCycleConfig() {
        return cycleConfig;
    }

    public void setCycleConfig(SignComponentCycleConfigParam cycleConfig) {
        this.cycleConfig = cycleConfig;
    }

    public SignComponentSupplementaryConfigParam getSupplementConfig() {
        return supplementConfig;
    }

    public void setSupplementConfig(SignComponentSupplementaryConfigParam supplementConfig) {
        this.supplementConfig = supplementConfig;
    }

    public List<SignComponentAdPositionConfigParam> getAdPositionConfig() {
        return adPositionConfig;
    }

    public void setAdPositionConfig(List<SignComponentAdPositionConfigParam> adPositionConfig) {
        this.adPositionConfig = adPositionConfig;
    }

    public SignComponentRewardConfigParam getRewardConfig() {
        return rewardConfig;
    }

    public void setRewardConfig(SignComponentRewardConfigParam rewardConfig) {
        this.rewardConfig = rewardConfig;
    }

    public SignComponentToolsConfigParam getToolsConfig() {
        return toolsConfig;
    }

    public void setToolsConfig(SignComponentToolsConfigParam toolsConfig) {
        this.toolsConfig = toolsConfig;
    }

    public String getDataJson() {
        return dataJson;
    }

    public void setDataJson(String dataJson) {
        this.dataJson = dataJson;
    }

    public JSONObject serialize2Json() {
        JSONObject extra = new JSONObject();
        extra.put(CYCLE_CONFIG, this.cycleConfig);
        extra.put(SUPPLEMENT_CONFIG, this.supplementConfig);
        extra.put(AD_POSITION_CONFIG, this.adPositionConfig);
        extra.put(REWARD_CONFIG, this.rewardConfig);
        extra.put(TOOLS_CONFIG, this.toolsConfig);
        extra.put(DATA_JSON, this.dataJson);
        extra.put(PUBLISH, this.publish);
        return extra;
    }

    public SignComponentActivityExtraParam(JSONObject extra) {
        this.cycleConfig = extra.getObject(CYCLE_CONFIG, SignComponentCycleConfigParam.class);
        this.supplementConfig = extra.getObject(SUPPLEMENT_CONFIG, SignComponentSupplementaryConfigParam.class);
        JSONArray apc = extra.getJSONArray(AD_POSITION_CONFIG);
        if (apc != null) {
            this.adPositionConfig = apc.toJavaList(SignComponentAdPositionConfigParam.class);
        }
        this.rewardConfig = extra.getObject(REWARD_CONFIG, SignComponentRewardConfigParam.class);
        this.toolsConfig = extra.getObject(TOOLS_CONFIG, SignComponentToolsConfigParam.class);
        this.dataJson = extra.getObject(DATA_JSON, String.class);
        this.publish = extra.getBooleanValue(PUBLISH);
    }

    public SignComponentActivityExtraParam() {
    }

}
