package cn.com.duiba.sign.center.api.enums.signcomponent;

import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * Created by 歪大哥😁 on 2019-08-22.
 */
public enum SignRewardTypeEnum {

    CONTINUITY_SIGN(0, "连续签到奖励"),
    TOTAL_SIGN(1, "累计签到奖励"),
    CONTINUITY_CYCLE(2, "连续周期奖励"),
    ;

    private static final Map<Integer, SignRewardTypeEnum> ALL_MAPPING;

    static {
        Map<Integer, SignRewardTypeEnum> temp = Maps.newHashMap();
        for (SignRewardTypeEnum value : values()) {
            temp.put(value.code, value);
        }
        ALL_MAPPING = temp;
    }

    private Integer code;
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    SignRewardTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    @CheckForNull
    public static SignRewardTypeEnum getType(Integer code) {
        return ALL_MAPPING.get(code);
    }
}
