
package cn.com.duiba.sign.center.api.remoteservice.signfornew;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signfornew.SignForNewDto;

import java.util.List;

/**
 * @author kimi
 * @version 1.0
 */
@AdvancedFeignClient
public interface RemoteSignForNewService {
	/**
	 * 创建新活动
	 * @param dto
	 * @return 活动id
	 */
	Long insert(SignForNewDto dto);

	/**
	 * 根据dto更新所有内容（设置null字段）
	 * @param dto
	 * @return
	 */
	Boolean updateById(SignForNewDto dto);

	/**
	 * 更新活动状态
	 * @param id
	 * @param open
	 * @return
	 */
	Boolean openSwitch(Long id, Boolean open);

	Boolean deleteById(Long id);

	SignForNewDto selectById(Long id);

	/**
	 * 仅提供给B端使用
	 * @param ids
	 * @return
	 */
	List<SignForNewDto> selectByIds(List<Long> ids);
}