package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.signpet.EffectiveConditionEnum;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetRewardEnum;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusEnum;
import cn.com.duiba.sign.center.api.enums.signpet.SignPetStatusTypeEnum;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liugq
 * @date created in 2018/4/23
 * @description:
 */
public class SignPetStatusDto implements Serializable{

    private static final long serialVersionUID = -1100784839585659725L;

    /**
     * id
     **/
    private Long id;
    /**
     * 活动ID
     **/
    private Long activityId;
    /**
     * 活动名称
     **/
    private String statusName;
    /**
     * 1:主动状态 2.被动状态
     **/
    private SignPetStatusTypeEnum statusType;
    /**
     * 状态值，1:正常 2:外出 3:吃饭 4:学习 5:喝水 6:睡觉
     **/
    private  SignPetStatusEnum petStatus;
    /**
     * 状态每天出现次数限制
     */
    private Integer statusCountLimit;
    /**
     * 持续时间,分钟
     **/
    private Integer duration;
    /**
     * 出现概率
     **/
    private Integer rate;
    /**
     * 是否可被打断(0-否，1-是)
     **/
    private Boolean canStop;
    /**
     * 1:无奖励、2:粮食、3.活动插件、4.集卡
     **/
    private SignPetRewardEnum awardType;
    /**
     * 活动插件id，或者集卡活动id
     **/
    private Long awardPluginId;
    /**
     * 每日奖励次数限制
     **/
    private Integer awardLimit;
    /**
     * 每次奖励次数
     */
    private Integer awardCount;
    /**
     * 状态可进入的起始时间,hh:mm
     **/
    private String startLimit;
    /**
     * 状态可进入的最晚时间,hh:mm
     **/
    private String endLimit;
    /**
     * 状态生效条件：0-无条件 1-吃饱 2-未吃饱
     */
    private EffectiveConditionEnum effectCondition;
    /**
     * 奖励概率
     */
    private Integer awardRate;
    /**
     * 两次触发此状态的间隔时间(分钟)
     */
    private Integer statusInterval;

    /**
     * 宠物配置id
     */
    private Long petConfigId;

    public Long getPetConfigId() {
        return petConfigId;
    }

    public void setPetConfigId(Long petConfigId) {
        this.petConfigId = petConfigId;
    }

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getActivityId() {
        return activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getStatusName() {
        return statusName;
    }

    public void setStatusName(String statusName) {
        this.statusName = statusName;
    }

    public SignPetStatusTypeEnum getStatusType() {
        return statusType;
    }

    public void setStatusType(SignPetStatusTypeEnum statusType) {
        this.statusType = statusType;
    }

    public SignPetStatusEnum getPetStatus() {
        return petStatus;
    }

    public void setPetStatus(SignPetStatusEnum petStatus) {
        this.petStatus = petStatus;
    }

    public Integer getDuration() {
        return duration;
    }

    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public Integer getRate() {
        return rate;
    }

    public void setRate(Integer rate) {
        this.rate = rate;
    }

    public Boolean getCanStop() {
        return canStop;
    }

    public void setCanStop(Boolean canStop) {
        this.canStop = canStop;
    }

    public SignPetRewardEnum getAwardType() {
        return awardType;
    }

    public void setAwardType(SignPetRewardEnum awardType) {
        this.awardType = awardType;
    }

    public Long getAwardPluginId() {
        return awardPluginId;
    }

    public void setAwardPluginId(Long awardPluginId) {
        this.awardPluginId = awardPluginId;
    }

    public Integer getAwardLimit() {
        return awardLimit;
    }

    public void setAwardLimit(Integer awardLimit) {
        this.awardLimit = awardLimit;
    }

    public Integer getAwardCount() {
        return awardCount;
    }

    public void setAwardCount(Integer awardCount) {
        this.awardCount = awardCount;
    }

    public String getStartLimit() {
        return startLimit;
    }

    public void setStartLimit(String startLimit) {
        this.startLimit = startLimit;
    }

    public String getEndLimit() {
        return endLimit;
    }

    public void setEndLimit(String endLimit) {
        this.endLimit = endLimit;
    }

    public Integer getStatusCountLimit() {
        return statusCountLimit;
    }

    public void setStatusCountLimit(Integer statusCountLimit) {
        this.statusCountLimit = statusCountLimit;
    }

    public EffectiveConditionEnum getEffectCondition() {
        return effectCondition;
    }

    public void setEffectCondition(EffectiveConditionEnum effectCondition) {
        this.effectCondition = effectCondition;
    }

    public Integer getAwardRate() {
        return awardRate;
    }

    public void setAwardRate(Integer awardRate) {
        this.awardRate = awardRate;
    }

    public Integer getStatusInterval() {
        return statusInterval;
    }

    public void setStatusInterval(Integer statusInterval) {
        this.statusInterval = statusInterval;
    }

    @Override
    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }
}
