package cn.com.duiba.sign.center.api.enums.creditssign;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/12/3.
 */
public enum SignSkinTypeEnum {
    CUSTOM(0, "自定义皮肤类型"),
    TEMPLATE(1, "模板皮肤类型");

    private static Map<Integer, SignSkinTypeEnum> typeEnumMap = new HashMap<>();

    static {
        for (SignSkinTypeEnum typeEnum : SignSkinTypeEnum.values()) {
            typeEnumMap.put(typeEnum.getCode(), typeEnum);
        }
    }


    private Integer code;
    private String desc;


    SignSkinTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    /**
     * 通过code获取签到来源类型
     *
     * @param code
     * @return
     */
    public static SignSkinTypeEnum getByCode(Integer code) {
        if (null == code){
            return null;
        }
        return typeEnumMap.get(code);
    }

}
