package cn.com.duiba.sign.center.api.enums.signcontract;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by Liugq on 2018/10/24.
 * 契约签到开奖类型
 */
public enum OpenTypeEnum {
    OPEN_TYPE_RATIO(0, "比例开奖"),
    OPEN_TYPE_RANDOM(1, "随机开奖"),
    ;

    private String desc;
    private int code;

    OpenTypeEnum(int code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    private static Map<Integer, OpenTypeEnum> typeMap = new HashMap<>();

    static {
        for (OpenTypeEnum typeEnum : values()) {
            typeMap.put(typeEnum.getCode(), typeEnum);
        }
    }

    /**
     *
     * @param code
     * @return
     */
    public static OpenTypeEnum getEnumByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return typeMap.get(code);
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }
}
