package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.SignPetLevelDto;
import cn.com.duiba.sign.center.api.params.SignPetLevelsSaveParam;

import java.util.List;

/**
 * Created by fangdong on 2018/07/11
 */
@AdvancedFeignClient
public interface RemoteSignPetLevelService {

    /**
     * 插入
     * @param level
     * @return
     */
    Long save(SignPetLevelDto level);

    /**
     * 更新
     * @param level
     * @return
     */
    Integer update(SignPetLevelDto level);

    /**
     * 批量保存
     * @param levelList
     * @return
     */
    @Deprecated
    Integer saveList(List<SignPetLevelDto> levelList);

    /**
     * 批量保存
     * @param param 保存参数
     */
    void saveLevelList(SignPetLevelsSaveParam param);

    /**
     * 根据活动id获取list
     * @param activityId
     * @return
     */
    List<SignPetLevelDto> listByActivityId(Long activityId);

    /**
     * 根据宠物配置id查询等级列表
     * @param activityId 活动id
     * @param petConfigId 宠物配置id
     * @return 等级列表
     */
    List<SignPetLevelDto> listByPetConfig(Long activityId, Long petConfigId);

    /**
     * 获取等级信息
     * @param level
     * @return
     */
    @Deprecated
    SignPetLevelDto getLevel(Long activityId, Integer level);

    /**
     * 根据宠物配置id，level数值查询等级配置
     * @param petConfigId 宠物配置id
     * @param activityId 活动id
     * @param level 等级数值
     * @return 等级配置
     */
    SignPetLevelDto getLevelByPetConfig(Long activityId, Long petConfigId, Integer level);

}
