package cn.com.duiba.sign.center.api.remoteservice.thirdparty;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.LiulishuoQuizDto;

/**
 * Created by fangdong on 2018/09/14
 */
@AdvancedFeignClient
public interface RemoteSignLiulishuoService {

    /**
     * 获取下一个计数器
     * @return counter
     * @throws BizException
     */
    Long getNextQuizCounter() throws BizException;

    /**
     * 获取答题计数器
     * @return 计数器
     * @throws BizException
     */
    Long getQuizCounter() throws BizException;

    /**
     * 保存答题计数器
     * @return
     * @throws BizException
     */
    Long saveQuizCounter(Long counter) throws BizException;

    /**
     * 轮询获取答题
     * @return 答题
     * @throws BizException
     */
    LiulishuoQuizDto getQuiz() throws BizException;

    /**
     * 根据id获取quiz
     * @param quizId quizId
     * @return
     * @throws BizException
     */
    LiulishuoQuizDto getQuizById(Long quizId) throws BizException;

    /**
     * 保存quiz
     * @param quiz quiz
     * @return quiz id
     * @throws BizException
     */
    Long saveQuiz(LiulishuoQuizDto quiz) throws BizException;

    /**
     * 获取答题数量
     * @return 答题数量
     * @throws BizException
     */
    Long countQuiz() throws BizException;

}
