package cn.com.duiba.sign.center.api.dto;

import cn.com.duiba.sign.center.api.enums.creditssign.SignTypeEnum;

import java.io.Serializable;
import java.util.Date;

/**
 * 签到记录DTO
 * Created by fangdong on 2018/06/14
 */
public class SignRecordDto implements Serializable {
    private static final long serialVersionUID = -5766114806094745858L;

    public static final int    TYPE_CONTINUE      = 0;                    // 联系
    public static final int    TYPE_CIRCLE        = 1;                    //周期

    private Long id;
    private Long appId;
    private Long consumerId;
    @Deprecated
    private Long signConfigId = 0L;
    /**
     * 连续签到时间
     */
    private Integer signDay;
    /**
     * 首次签到时间
     */
    private Date firstSignDay;
    /**
     * 最后签到时间
     */
    private Date endSignDay;
    /**
     * 签到类型
     */
    private SignTypeEnum signType;
    private Date gmtCreate;
    private Date gmtModified;


    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getConsumerId() {
        return consumerId;
    }

    public void setConsumerId(Long consumerId) {
        this.consumerId = consumerId;
    }

    /**
     * @deprecated (when, why, refactoring advice...)
     */
    @Deprecated
    public Long getSignConfigId() {
        return signConfigId;
    }

    /**
     * @deprecated (when, why, refactoring advice...)
     */
    @Deprecated
    public void setSignConfigId(Long signConfigId) {
        this.signConfigId = signConfigId;
    }

    public Integer getSignDay() {
        return signDay;
    }

    public void setSignDay(Integer signDay) {
        this.signDay = signDay;
    }

    public Date getFirstSignDay() {
        return firstSignDay;
    }

    public void setFirstSignDay(Date firstSignDay) {
        this.firstSignDay = firstSignDay;
    }

    public Date getEndSignDay() {
        return endSignDay;
    }

    public void setEndSignDay(Date endSignDay) {
        this.endSignDay = endSignDay;
    }

    public SignTypeEnum getSignType() {
        return signType;
    }

    public void setSignType(SignTypeEnum signType) {
        this.signType = signType;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }

    @Override
    public String toString() {
        return "SignRecordDto{" +
                "id=" + id +
                ", appId=" + appId +
                ", consumerId=" + consumerId +
                ", signConfigId=" + signConfigId +
                ", signDay=" + signDay +
                ", firstSignDay=" + firstSignDay +
                ", endSignDay=" + endSignDay +
                ", signType=" + signType +
                ", gmtCreate=" + gmtCreate +
                ", gmtModified=" + gmtModified +
                '}';
    }
}
