package cn.com.duiba.sign.center.api.enums.signcomponent;

import com.google.common.collect.Maps;

import javax.annotation.CheckForNull;
import java.util.Map;

/**
 * 签到组件化 签到周期类型
 * Created by 歪大哥😁 on 2019-08-22.
 */
public enum SignCycleTypeEnum {

    CONTINUITY(0, "连续签到"),
    CONTINUITY_CYCLE(10, "连续周期"),
    CUSTOM_CYCLE(20, "自定义签到周期"),
    ;

    private static final Map<Integer, SignCycleTypeEnum> ALL_MAPPING;

    static {
        Map<Integer, SignCycleTypeEnum> temp = Maps.newHashMap();
        for (SignCycleTypeEnum value : values()) {
            temp.put(value.code, value);
        }
        ALL_MAPPING = temp;
    }

    private Integer code;
    private String desc;

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public int getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    SignCycleTypeEnum(Integer code, String desc) {
        this.desc = desc;
        this.code = code;
    }

    @CheckForNull
    public static SignCycleTypeEnum getType(Integer code) {
        return ALL_MAPPING.get(code);
    }

}
