package cn.com.duiba.sign.center.api.remoteservice.signpet;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.sign.center.api.dto.signpet.SignPetConfigDto;

import java.util.List;

/**
 * Created by fangdong on 2019/08/01
 */
@AdvancedFeignClient
public interface RemoteSignPetConfigService {

    /**
     * 根据id查询
     * @param id 主键
     * @return 宠物配置
     * @throws BizException
     */
    SignPetConfigDto getById(Long id);

    /**
     * 保存
     * @param petConfig 宠物配置
     * @return 主键
     * @throws BizException
     */
    Long save(SignPetConfigDto petConfig) throws BizException;

    /**
     * 根据活动id获取宠物配置列表
     * @param activityId 活动id
     * @return 宠物配置列表
     * @throws Exception
     */
    List<SignPetConfigDto> listByActivity(Long activityId);

    /**
     * 删除
     * @param ids id列表
     * @return 删除数量
     * @throws Exception
     */
    Integer deleteList(List<Long> ids) throws BizException;

    Integer deleteByActivityId(Long activityId);
}
