package cn.com.duiba.cloud.single.sign.on.client.cache.impl;

import cn.com.duiba.cloud.single.sign.on.client.cache.LoginStateCache;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

/**
 * @author xuanhongjian
 */
public class DefaultLoginStateCache implements LoginStateCache {

    private final Cache<String, LoginStateDto> loginStateCache = Caffeine.newBuilder()
                                                                     .expireAfterWrite(5,
                                                                         TimeUnit.SECONDS).build();

    /**
     * 失效本地登录态
     *
     * @param keys ticket
     */
    @Override
    public void invalidateAll(List<String> keys) {
        Assert.notEmpty(keys, "失效的key不能为空");
        loginStateCache.invalidateAll(keys);
    }

    /**
     * 获取登录态
     *
     * @param key ticket
     * @return 登录态
     */
    @Override
    public LoginStateDto get(String key) {
        Assert.isTrue(StringUtils.isNotBlank(key), "ticket不能为空");
        return loginStateCache.getIfPresent(key);
    }

    /**
     * 把登录态设置进缓存
     *
     * @param key ticket
     * @param loginStateDto 登录态
     */
    @Override
    public void set(String key, LoginStateDto loginStateDto,Long expire) {
        Assert.isTrue(StringUtils.isNotBlank(key) && Objects.nonNull(loginStateDto), "ticket不能为空");
        loginStateCache.put(key, loginStateDto);
    }

    /**
     * 失效过期的ticket
     *
     * @param key ticket
     */
    @Override
    public void invalidate(String key) {
        Assert.isTrue(StringUtils.isNotBlank(key),"ticket不能为空");
        loginStateCache.invalidate(key);
    }
}
