package cn.com.duiba.cloud.single.sign.on.client.config;

import java.util.Properties;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;

/**
 * 强行打开csrf安全机制
 * @author xuanhongjian
 */
public class SsoWebEnvApplicationInitializer implements EnvironmentPostProcessor {

    @Override
    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        Properties properties = new Properties();
        properties.put("duiba.security.csrf.enable",true);
        PropertiesPropertySource propertiesPropertySource = new PropertiesPropertySource("ssoWebConfig", properties);
        environment.getPropertySources().addLast(propertiesPropertySource);
    }
}
