package cn.com.duiba.cloud.single.sign.on.client.remoteservice;


import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.cloud.single.sign.on.client.domain.dto.LoginStateDto;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.RequestParam;


/**
 * @author xuanhongjian
 */
@AdvancedFeignClient
public interface RemoteSsoService {


    /**
     * 登录验证接口
     * @param ticket 待校验的凭证
     * @return 验证失败返回null
     */
    LoginStateDto verifyTicket(@NotNull String ticket);

    /**
     * 获取Sso域名地址
     * @return 重定向地址
     */
    String findSsoHomeUrl();


    /**
     * 根据stamp 获取ticket
     *
     * @param ssoStamp 临时凭证
     * @return sso ticket
     */
    String findTicketByStamp(Long ssoStamp);

    /**
     * 退出登录
     * @param ticket ticket
     * @return 退出登录
     */
    Boolean outLogin( String ticket);
}
