package cn.com.duiba.cloud.single.sign.on.client.web;

import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoRunTimeException;
import cn.com.duiba.cloud.single.sign.on.contract.tool.JsonRender;
import cn.com.duibaboot.ext.autoconfigure.security.exception.DuibaSecurityException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;

/**
 * @author xuanhongjian
 */
@ControllerAdvice
public class GlobalControllerAdvice {

    @ResponseBody
    @ExceptionHandler({SsoException.class, SsoRunTimeException.class, DuibaSecurityException.class})
    public JsonRender<Void> exceptionHandler(Exception e) {
        return JsonRender.error(e);
    }
}
