package cn.com.duiba.cloud.single.sign.on.contract;


import cn.com.duiba.cloud.single.sign.on.contract.constants.SsoProperties;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.SsoFilterHandlerQueue;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.SsoInterceptor;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * @author xuanhongjian
 */
@Configuration
@EnableConfigurationProperties(SsoProperties.class)
@Order(-1)
public class SsoAutoConfiguration implements WebMvcConfigurer {

    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private ApplicationContext applicationContext;

    @Override
    public void addInterceptors(InterceptorRegistry registry) {

        String pathPatterns = ssoProperties.getPathPatterns();
        String[] paths = StringUtils.split(pathPatterns, ",");

        String excludePathPatterns = ssoProperties.getExcludePathPatterns();
        String[] excludePath = StringUtils.isEmpty(excludePathPatterns) ? new String[]{}
                                   : StringUtils.split(excludePathPatterns, ",");

        SsoInterceptor ssoInterceptor = applicationContext.getBean(SsoInterceptor.class);
        registry.addInterceptor(ssoInterceptor)
            .addPathPatterns(paths)
            .addPathPatterns("/auth/**")
            //sso内置开放接口
            .addPathPatterns("/sso/**")
            //排除移动端的链接
            .excludePathPatterns(excludePath);
    }

    @Bean
    @ConditionalOnMissingBean
    public SsoInterceptor ssoInterceptor(List<SsoFilterHandler> ssoFilterHandlers) {
        SsoFilterHandlerQueue queue = new SsoFilterHandlerQueue();
        SsoInterceptor ssoInterceptor = new SsoInterceptor();
        for (SsoFilterHandler handler : ssoFilterHandlers) {
            queue.addHandler(handler);
        }
        ssoInterceptor.setHandleQueue(queue);
        return ssoInterceptor;
    }

}
