package cn.com.duiba.cloud.single.sign.on.contract.constants;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * @author 宣洪剑
 */
@Data
@ConfigurationProperties(prefix = "duiba.sso")
public class SsoProperties {

    /**
     * 一级path
     */
    private String rootPath = "";

    /**
     * 登录成功后默认的跳转地址，一般为首页地址
     */
    private String defaultRedirectUrl = "/";

    /**
     * sso要拦截的url，配置多个地址用","分隔
     * 若没配置，就采用默认值/** 拦截所有
     */
    private String pathPatterns = "/**";

    /**
     * 排除的路径，sso不拦截
     */
    private String excludePathPatterns;
}

