package cn.com.duiba.cloud.single.sign.on.contract.interceptor;


import cn.com.duiba.cloud.single.sign.on.contract.common.exception.SsoException;
import cn.com.duiba.cloud.single.sign.on.contract.interceptor.handler.SsoFilterHandler;
import com.google.common.collect.Lists;
import java.util.List;

/**
 * @author xuanhongjian
 */
public class SsoFilterHandlerQueue {

    private final List<SsoFilterHandler> queueHandlerList = Lists.newArrayList();

    public void addHandler(SsoFilterHandler bootFilterHandler) {
        queueHandlerList.add(bootFilterHandler);
    }

    public Boolean doHandler(Object handler) throws SsoException {
        if (queueHandlerList.isEmpty()) {
            return true;
        }
        for (SsoFilterHandler itemHandler : queueHandlerList) {
            if (!itemHandler.before(handler)) {
                return false;
            }
        }
        return true;
    }
}
