package cn.com.duiba.cloud.single.sign.on.contract.tool;

import java.io.Serializable;
import java.util.function.Supplier;
import javax.validation.constraints.NotNull;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.slf4j.Logger;
import org.springframework.util.Assert;

/**
 * 请求响应结果
 * @author xuanhongjian
 */
@Data
@Slf4j
public class JsonRender<T> implements Serializable {

    public static final String SUCCESS_CODE = "200";
    public static final String ERROR_CODE = "500";
    public static final String RPC_ERROR_CODE = "RPC_ERROR";
    public static final String SUCCESS_MESSAGE = "操作成功!";
    public static final String RPC_ERROR = "系统繁忙,请稍后重试!";
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1475348231900998033L;
    private String code;

    private Boolean success;

    private String message;

    private T result;

    @SuppressWarnings("unused")
    public JsonRender() {
        this(true, SUCCESS_CODE, SUCCESS_MESSAGE);
    }

    public JsonRender(boolean isSuccess, String code, String message) {
        this.success = isSuccess;
        this.code = code;
        this.message = message;
    }

    public static <T> JsonRender<T> success() {
        return new JsonRender<>(true, SUCCESS_CODE, SUCCESS_MESSAGE);
    }

    public static <T> JsonRender<T> success(T data) {
        JsonRender<T> result = new JsonRender<>(true, SUCCESS_CODE, SUCCESS_MESSAGE);
        result.setResult(data);
        return result;
    }

    public static <T> JsonRender<T> error(String message) {
        return new JsonRender<>(false, ERROR_CODE, message);
    }

    @SuppressWarnings("unused")
    public static <T> JsonRender<T> error(T data, String message) {
        JsonRender<T> result = new JsonRender<>(false, ERROR_CODE, message);
        result.setResult(data);
        return result;
    }

    public static <T> JsonRender<T> rpcError() {
        return new JsonRender<>(false, RPC_ERROR_CODE, RPC_ERROR);
    }

    @SuppressWarnings("unused")
    public static <T> JsonRender<T> rpcError(String message) {
        return new JsonRender<>(false, RPC_ERROR_CODE, message);
    }

    public static <T> JsonRender<T> error(String message, String code) {
        JsonRender<T> result = new JsonRender<>(false, code, message);
        result.setCode(code);
        return result;
    }

    public static <T> JsonRender<T> error(Throwable throwable) {
        return JsonRender.error(throwable.getMessage());
    }

    /**
     * RpcErrorLogUtil
     */
    @SuppressWarnings("unused")
    public static <T> JsonRender<T> writeLog(Logger logger, String rpcErrorMessage, Object request,
        Throwable cause) {
        logger.error("rpcError," + rpcErrorMessage + ",request:{}", request, cause);
        return JsonRender.rpcError();
    }

    /**
     * 调用远程服务，不校验返回结果是否为空
     */
    public static <T> T call(@NotNull Supplier<JsonRender<T>> supplier) {

        JsonRender<T> jsonRender = supplier.get();

        Assert.state(jsonRender.getSuccess(), "远程服务调用成功，服务执行失败: " + jsonRender.getMessage());

        return jsonRender.getResult();
    }

    /**
     * 调用远程服务，校验返回结果是否为空
     */
    @SuppressWarnings("unused")
    public static <T> T callAndCheckNotNull(@NotNull Supplier<JsonRender<T>> supplier) {
        T t = call(supplier);
        Assert.notNull(t, "远程服务调用成功，返回结果为空");
        return t;
    }

    @SuppressWarnings("unused")
    public String toBriefString() {
        return "JsonRender(code=" + this.getCode() + ", success=" + this.getSuccess() + ", message="
                   + this.getMessage() + ")";
    }
}
