/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.factory;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.wolf.utils.ClassUtils;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class SsoBeanFactory {
    private static SsoBeanFactory ssoBeanFactory;
    private SsoContext context;
    private ApplicationContext applicationContext;
    private Map<Class<?>, Object> classMap = Maps.newConcurrentMap();

    private SsoBeanFactory() {
    }

    public static SsoBeanFactory newInstance(SsoContext context) {
        try {
            if (ssoBeanFactory != null) {
                return ssoBeanFactory;
            }
            ssoBeanFactory = new SsoBeanFactory();
            ssoBeanFactory.setSsoContext(context);
            return ssoBeanFactory;
        }
        catch (Exception e) {
            throw new SsoRunTimeException("SSO\u5ba2\u6237\u7aef\u521d\u59cb\u5316\u5f02\u5e38", e);
        }
    }

    public void setSsoContext(SsoContext context) {
        this.context = context;
        this.applicationContext = context.getApplicationContext();
    }

    public <T> T getBean(Class<T> clazz) {
        try {
            if (this.classMap.containsKey(clazz)) {
                return (T)this.classMap.get(clazz);
            }
            return (T)this.applicationContext.getBean(clazz);
        }
        catch (Exception e) {
            throw new SsoRunTimeException(e);
        }
    }

    protected void scan() {
        try {
            List<Class<?>> classes = ClassUtils.getClassList((String)"cn.com.duiba.sso.api", (boolean)true, null);
            classes = this.filterClassByAnnotation(classes, SsoComponent.class);
            for (Class<?> clazz : classes) {
                if (this.classMap.containsKey(clazz)) continue;
                this.classMap.put(clazz, clazz.newInstance());
            }
            for (Class<?> clazz : classes) {
                Object bean = this.classMap.get(clazz);
                if (!(bean instanceof SsoBeanAware)) continue;
                SsoBeanAware ssoBeanAware = (SsoBeanAware)bean;
                ssoBeanAware.setContext(this.context);
            }
        }
        catch (Exception e) {
            throw new SsoRunTimeException("Sso\u521d\u59cb\u5316\u5bb9\u5668\u5931\u8d25", e);
        }
    }

    private List<Class<?>> filterClassByAnnotation(List<Class<?>> classes, Class<? extends Annotation> annotationType) {
        ArrayList newList = Lists.newArrayList();
        for (Class<?> clazz : classes) {
            Annotation annotation = AnnotationUtils.findAnnotation(clazz, annotationType);
            if (Objects.equal((Object)annotation, null)) continue;
            newList.add(clazz);
        }
        return newList;
    }

    public Set<Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        Map bean = this.applicationContext.getBeansWithAnnotation(annotationType);
        HashSet beans = Sets.newHashSet();
        beans.addAll(bean.values());
        Set<Class<?>> classes = this.classMap.keySet();
        List beanList = Lists.transform((List)Lists.newArrayList(classes), (Function)new Function<Class<?>, Object>(){

            public Object apply(Class<?> input) {
                return SsoBeanFactory.this.classMap.get(input);
            }
        });
        beans.addAll(beanList);
        return beans;
    }
}

