/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.factory;

import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.web.factory.SsoBeanFactory;
import cn.com.duiba.sso.api.web.tool.SsoSystemProperties;
import com.google.common.base.Objects;
import java.lang.annotation.Annotation;
import java.util.Set;
import org.springframework.context.ApplicationContext;

public class SsoContext {
    private SsoBeanFactory ssoBeanFactory;
    private SsoSystemProperties properties;
    private ApplicationContext applicationContext;

    public SsoContext(ApplicationContext applicationContext, SsoSystemProperties properties) {
        this.properties = properties;
        this.applicationContext = applicationContext;
    }

    public void setSsoBeanFactory(SsoBeanFactory ssoBeanFactory) {
        this.ssoBeanFactory = ssoBeanFactory;
        this.ssoBeanFactory.scan();
    }

    public <T> T getBean(Class<T> clazz) {
        T bean = this.ssoBeanFactory.getBean(clazz);
        if (Objects.equal(bean, null)) {
            throw new SsoRunTimeException("SSO\u7cfb\u7edf\u4f9d\u8d56\u7684Bean:" + clazz.getName() + "\u4e0d\u5b58\u5728");
        }
        return bean;
    }

    public SsoSystemProperties getSsoSystemProperties() {
        return this.properties;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public Set<Object> getBeansWithAnnotation(Class<? extends Annotation> annotationType) {
        return this.ssoBeanFactory.getBeansWithAnnotation(annotationType);
    }
}

