/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.filter;

import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoBeanAware;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.wolf.utils.ClassUtils;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.servlet.FilterChain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SsoComponent
public class SsoFilterHandlerQueue
implements SsoBeanAware {
    private Logger logger = LoggerFactory.getLogger(SsoFilterHandlerQueue.class);
    private List<SsoFilterHandler> queueHandlerList;
    private Integer length = 0;

    @Override
    public void setContext(SsoContext context) {
        try {
            List classes = ClassUtils.getClassList((String)"cn.com.duiba.sso.api.web.filter.filterhandler.handler", (boolean)true, null);
            ArrayList handlerList = Lists.newArrayList();
            HashSet orderSet = Sets.newHashSet();
            for (Class clazz : classes) {
                if (!SsoFilterHandler.class.isAssignableFrom(clazz)) continue;
                SsoFilterHandler ssoFilterHandler = (SsoFilterHandler)context.getBean(clazz);
                orderSet.add(ssoFilterHandler.getOrder());
                handlerList.add(ssoFilterHandler);
            }
            if (orderSet.size() != handlerList.size()) {
                throw new SsoRunTimeException("Sso\u62e6\u622a\u5e8f\u5217\u5b58\u5728");
            }
            Ordering ordering = Ordering.natural().onResultOf((Function)new Function<SsoFilterHandler, Integer>(){

                public Integer apply(SsoFilterHandler input) {
                    return input.getOrder();
                }
            });
            this.queueHandlerList = ordering.sortedCopy((Iterable)handlerList);
            this.length = this.queueHandlerList.size();
            this.logger.error("\u68c0\u6d4b\u5230\u62e6\u622a\u961f\u5217\u6570:" + this.length);
        }
        catch (Exception e) {
            new SsoRunTimeException(e);
        }
    }

    public void doHandler(FilterChain chain) throws SsoException {
        SsoFilterHandler handler;
        boolean doNext;
        Iterator<SsoFilterHandler> iterator = this.queueHandlerList.iterator();
        while (iterator.hasNext() && (doNext = (handler = iterator.next()).doHandler(chain).booleanValue())) {
        }
    }

    public Integer size() {
        return this.length;
    }
}

