/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@SsoComponent
public class AuthorityFilterHandler
extends SsoFilterHandler {
    private SystemEnum system;
    private Splitter spl = Splitter.on((String)"/").trimResults().omitEmptyStrings();

    @Override
    public Integer getOrder() {
        return -99;
    }

    @Override
    public void setContext(SsoContext context) {
        this.system = context.getSsoSystemProperties().getSystem();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        AdminDto admin = RequestTool.getAdmin();
        if (!admin.getCompanyEnumSet().contains((Object)this.system)) {
            throw new SsoException("\u5c0a\u656c\u7684" + admin.getName() + "\uff0c\u60a8\u6682\u65f6\u6ca1\u6709" + this.system.getName() + "\u7684\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458@\u4e01\u6668");
        }
        HttpServletRequest request = RequestTool.getRequest();
        HttpServletResponse response = RequestTool.getResponse();
        Long adminId = RequestTool.getAdminId();
        String accept = request.getHeader("Accept");
        String url = request.getRequestURI();
        boolean isSuperAdmin = admin.getSuperAdmin();
        if (isSuperAdmin) {
            return true;
        }
        Set<String> urlBlackSet = RequestTool.getUrlBlackSet(adminId.intValue(), this.system.getId().intValue());
        if (!urlBlackSet.contains(url)) {
            return true;
        }
        if (accept.contains("json")) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)-1);
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u60a8\u65e0\u6743\u8bbf\u95ee");
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            try {
                response.getWriter().write(json.toJSONString());
            }
            catch (IOException e) {
                throw new SsoException(e);
            }
            return false;
        }
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write("\u65e0\u6743\u8bbf\u95ee");
        }
        catch (IOException e) {
            throw new SsoException(e);
        }
        return false;
    }
}

