/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.filter.filterhandler.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.web.annotation.SsoComponent;
import cn.com.duiba.sso.api.web.factory.SsoContext;
import cn.com.duiba.sso.api.web.filter.filterhandler.SsoFilterHandler;
import cn.com.duiba.sso.api.web.tool.CookieUtil;
import cn.com.duiba.sso.api.web.tool.RequestTool;
import cn.com.duiba.wolf.dubbo.DubboResult;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.net.URLEncoder;
import javax.servlet.FilterChain;

@SsoComponent
public class LoginFilterHandler
extends SsoFilterHandler {
    private RemoteSSOService remoteSSOService;
    private String ssoSystemUrl;
    private String redirectUrl;
    private SystemEnum system;

    @Override
    public Integer getOrder() {
        return -100;
    }

    @Override
    public void setContext(SsoContext context) {
        this.remoteSSOService = context.getBean(RemoteSSOService.class);
        this.ssoSystemUrl = context.getSsoSystemProperties().getSsoSystemUrl();
        this.system = context.getSsoSystemProperties().getSystem();
        this.redirectUrl = context.getSsoSystemProperties().getDefaultRedirectUrl();
    }

    @Override
    public Boolean doHandler(FilterChain chain) throws SsoException {
        String ticket = RequestTool.findTicket();
        DubboResult<AdminDto> adminIdRes = this.remoteSSOService.verifyTicketToAdmin(ticket);
        if (!adminIdRes.isSuccess() || Objects.equal(null, (Object)adminIdRes.getResult())) {
            try {
                if (RequestTool.isAsynchronousRequests().booleanValue()) {
                    RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                    JSONObject model = new JSONObject();
                    model.put("success", (Object)false);
                    model.put("notLogin", (Object)true);
                    model.put("message", (Object)adminIdRes.getMsg());
                    RequestTool.getResponse().getWriter().write(model.toJSONString());
                } else {
                    String url;
                    if ("/".equals(this.redirectUrl)) {
                        url = URLEncoder.encode(RequestTool.getUrl(), "utf-8");
                    } else {
                        String scheme = RequestTool.getRequest().getScheme();
                        String serverName = RequestTool.getRequest().getServerName();
                        int port = RequestTool.getRequest().getServerPort();
                        String domainUrl = scheme + "://" + serverName + ":" + port;
                        url = URLEncoder.encode(domainUrl + this.redirectUrl, "utf-8");
                    }
                    RequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl(url));
                }
            }
            catch (Exception e) {
                throw new SsoException(e);
            }
            return false;
        }
        AdminDto admin = (AdminDto)adminIdRes.getResult();
        RequestTool.setAdmin(admin);
        if (RequestTool.getRequestParamMap().containsKey("sso_ticket")) {
            CookieUtil.setCookie("sso_ticket", ticket);
        }
        return true;
    }

    private String getLoginRedirectUrl(String redirect) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLoginUrl()).append("?redirect=").append(redirect);
        builder.append("&system=").append(this.system.getId());
        return builder.toString();
    }

    private String getLoginUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.ssoSystemUrl).append("/login");
        return sb.toString();
    }
}

