/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.logger.runnable;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.enums.SystemEnum;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerParams;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.tool.RequestParams;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SsoLoggerRunnable
implements Runnable {
    private Logger logger = LoggerFactory.getLogger(SsoLoggerRunnable.class);
    private SsoLoggerTheadContext context;
    private RequestParams requestParams;
    private RemoteManagerLogService remoteManagerLogService;
    private SystemEnum system;

    @Override
    public void run() {
        AdminDto admin = this.requestParams.getAdmin();
        Long adminId = 0L;
        String adminName = "\u514d\u9a8c\u8bf7\u6c42";
        if (!Objects.equal(null, (Object)admin)) {
            adminId = admin.getId();
            adminName = admin.getName();
        }
        List<JSONObject> paramsList = this.context.getParams();
        for (JSONObject log : paramsList) {
            JSONObject model = new JSONObject();
            model.put("adminId", (Object)adminId);
            model.put("adminName", (Object)adminName);
            model.putAll((Map)log);
            String logContext = this.replaceArgs(this.context.getTemplate(), model);
            SsoLoggerParams params = new SsoLoggerParams();
            params.setAdminId(adminId);
            params.setGroup(this.context.getGroup());
            params.setSystem(this.system);
            params.setIp(this.requestParams.getIp());
            params.setParamsJson(log);
            params.setLogContent(logContext);
            this.remoteManagerLogService.log(params);
        }
    }

    private String replaceArgs(String template, JSONObject data) {
        StringBuffer sb = new StringBuffer();
        try {
            Pattern pattern = Pattern.compile("\\$\\{(.+?)\\}");
            Matcher matcher = pattern.matcher(template);
            while (matcher.find()) {
                String name = matcher.group(1);
                String value = "";
                if (data.containsKey((Object)name)) {
                    value = data.getString(name);
                    value = value.replaceAll("\\$", "\\\\\\$");
                }
                matcher.appendReplacement(sb, value);
            }
            matcher.appendTail(sb);
        }
        catch (Exception e) {
            this.logger.error("\u7ba1\u7406\u5458\u64cd\u4f5c\u65e5\u5fd7\u6e32\u67d3\u5931\u8d25", (Throwable)e);
        }
        System.out.println("\u65e5\u5fd7:" + sb.toString());
        return sb.toString();
    }

    public SsoLoggerTheadContext getContext() {
        return this.context;
    }

    public void setContext(SsoLoggerTheadContext context) {
        this.context = context;
    }

    public RequestParams getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }

    public SystemEnum getSystem() {
        return this.system;
    }

    public void setSystem(SystemEnum system) {
        this.system = system;
    }
}

