package cn.com.duiba.sso.api.web.interceptor;

import java.util.List;

import javax.annotation.Resource;

import cn.com.duiba.sso.api.exception.SsoException;
import org.springframework.stereotype.Component;

/**
 * Created by liuyao on 2017/5/11.
 */
@Component
public class SsoFilterHandlerQueue {

    @Resource
    private List<SsoFilterHandler> queueHandlerList;

    public Boolean doHandler(Object handler) throws SsoException {
        if(queueHandlerList.isEmpty()){
            return true;
        }
        for(SsoFilterHandler itemHandler:queueHandlerList){
            boolean doNext = itemHandler.doHandler(handler);
            if(!doNext){
               return false;
            }
        }
        return true;
    }

    public Integer size(){
        return queueHandlerList.size();
    }
}
