package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.web.power.PowerCache;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Set;

/**
 * Created by liuyao on 2017/5/12.
 * 远程权限拦截系统
 */
@Component
public class AuthorityFilterHandler extends SsoFilterHandler {


    @Override
    public int getOrder() {
        return -99;
    }
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    @Override
    public Boolean doHandler(Object handler) throws SsoException {
        AdminDto admin = RequestTool.getAdmin();
//        if(admin.getSuperAdmin()){
//            return true;
//        }
        SystemDto system = SystemInfo.getThisSystemInfo();
        if(!admin.getSystemIdSet().contains(system.getId())){
            throw new SsoException("尊敬的"+admin.getName()+"，您暂时没有"+system.getAppName()+"的访问权限，请联系本部门HR开通");
        }

        if(handler instanceof HandlerMethod){
            HandlerMethod method = (HandlerMethod)handler;
            AuthCanAccess canAccess = AnnotationUtils.findAnnotation(method.getMethod(),AuthCanAccess.class);
            if(!Objects.equal(null,canAccess)){
                return true;
            }
        }
        HttpServletRequest request = RequestTool.getRequest();
        HttpServletResponse response = RequestTool.getResponse();

        String url = request.getRequestURI();

        if(adminPowerCacheService.hasPower(admin.getId(),url)){
            return true;
        }else{
            if(RequestTool.isAsynchronousRequests()){
                JSONObject json = new JSONObject();
                json.put("code","SSO:01002");
                json.put("success",false);
                json.put("desc","您无权访问");
                response.setHeader("Content-Type", "application/json;charset=UTF-8");
                try {
                    response.getWriter().write(json.toJSONString());
                } catch (IOException e) {
                    throw new SsoException(e);
                }
            }else{//重定向到无权页面
                try {
                    response.setHeader("Content-Type", "text/html;charset=UTF-8");
                    response.getWriter().write("无权访问");
                } catch (IOException e) {
                    throw new SsoException(e);
                }
            }
            return false;
        }
    }
}
