package cn.com.duiba.sso.api.web.logger;

import cn.com.duiba.sso.api.web.logger.annotation.SsoLoggerMethod;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;

/**
 * Created by liuyao on 2017/12/5.
 */
@Aspect
@Component
public class SsoLoggerInterceptor {

    @Pointcut("@annotation(cn.com.duiba.sso.api.web.logger.annotation.SsoLoggerMethod)")
    public void logger(){}

    @Before("logger()")
    public void loggerBefore(JoinPoint point){
        MethodSignature methodSignature = (MethodSignature) point.getSignature();
        Method method = methodSignature.getMethod();
        SsoLoggerMethod ssoLoggerMethod = AnnotationUtils.findAnnotation(method,SsoLoggerMethod.class);
        String template = ssoLoggerMethod.value();
        String group = ssoLoggerMethod.group();

        SsoLoggerTheadContext context = new SsoLoggerTheadContext();
        context.setTemplate(template);
        context.setGroup(group);
        SsoLogger.setSsoLoggerTheadContext(context);
    }

    @After("logger()")
    public void loggerAfter(){
        SsoLogger.flush();
    }

}
