package cn.com.duiba.sso.api.web.logger.runnable;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.logger.domain.AccessLog;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.SystemInfo;

import java.text.SimpleDateFormat;
import java.util.Date;

public class AccessLoggerRunnable implements Runnable {

    private RequestParams requestParams;

    private RemoteManagerLogService remoteManagerLogService;

    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    private String requestFunction;

    @Override
    public void run() {

        AdminDto admin = requestParams.getAdmin();
        SystemDto thisSystem = SystemInfo.getThisSystemInfo();

        AccessLog accessLog = new AccessLog();
        accessLog.setAccessUser(admin.getName());
        accessLog.setRequestUrl(requestParams.getUrl());
        accessLog.setRequestUri(requestParams.getUri());
        accessLog.setIp(requestParams.getIp());
        accessLog.setSystemId(thisSystem.getId());
        accessLog.setBusinessSystem(thisSystem.getAppName());
        accessLog.setAccessTime(sdf.format(new Date()));
        accessLog.setRequestFunction(requestFunction);
        remoteManagerLogService.appendAccessLog(accessLog);
    }




    public void setRequestParams(RequestParams requestParams) {
        this.requestParams = requestParams;
    }


    public void setRequestFunction(String requestFunction) {
        this.requestFunction = requestFunction;
    }

    public void setRemoteManagerLogService(RemoteManagerLogService remoteManagerLogService) {
        this.remoteManagerLogService = remoteManagerLogService;
    }
}
