package cn.com.duiba.sso.api.web.logger.service;

import java.util.concurrent.ExecutorService;

import cn.com.duiba.sso.api.web.logger.SsoLogger;
import cn.com.duiba.sso.api.web.logger.domain.SsoLoggerTheadContext;
import cn.com.duiba.sso.api.web.logger.runnable.AccessLoggerRunnable;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;

import cn.com.duiba.sso.api.remoteservice.RemoteManagerLogService;
import cn.com.duiba.sso.api.web.logger.runnable.SsoLoggerRunnable;
import cn.com.duiba.sso.api.tool.RequestParams;
import cn.com.duiba.sso.api.tool.RequestTool;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;

/**
 * Created by liuyao on 2017/6/19.
 */
@Component
public class SsoLoggerService implements InitializingBean {

    @Resource
    private ExecutorService executorService;
    @Resource
    private RemoteManagerLogService remoteManagerLogService;

    /**
     * 由切面产生,如果没有此日志线程对象,则SsoLogger的无法打印日志
     */
    private ThreadLocal<SsoLoggerTheadContext> threadContext = new ThreadLocal();

    /**
     * 打印日志
     * @param json
     */
    public void log(JSONObject json){
        threadContext.get().addParams(json);
    }

    /**
     *
     * @param context
     */
    public void setThreadContext(SsoLoggerTheadContext context){
        //不支持嵌套(如果要支持嵌套,threadContext的数据结构需要弄成栈表形式)
        if(threadContext.get()==null){
            threadContext.set(context);
        }
    }

    /**
     * 打印业务日志
     */
    public void flushThreadContext(){
        SsoLoggerTheadContext context = threadContext.get();
        if(Objects.equal(null,context)){
            return;
        }
        //克隆出一个 RequestParams
        RequestParams params = RequestTool.getRequestParams();
        SsoLoggerRunnable runnable = new SsoLoggerRunnable();
        runnable.setRequestParams(params);
        runnable.setContext(context);
        runnable.setRemoteManagerLogService(remoteManagerLogService);
        executorService.submit(runnable);
        threadContext.remove();
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        SsoLogger.setSsoLoggerService(this);
    }

    /**
     * 打印访问日志
     * @param runnable
     */
    public void sendAccessLog(AccessLoggerRunnable runnable) {
        runnable.setRemoteManagerLogService(remoteManagerLogService);
        executorService.submit(runnable);
    }
}
