/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.domain.dto.SystemDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import cn.com.duiba.sso.api.web.interceptor.annotation.AuthCanAccess;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Objects;
import java.io.IOException;
import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;
import org.springframework.web.method.HandlerMethod;

@Component
public class AuthorityFilterHandler
extends SsoFilterHandler {
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;

    public int getOrder() {
        return -99;
    }

    @Override
    public Boolean before(Object handler) throws SsoException {
        HandlerMethod method;
        AuthCanAccess canAccess;
        AdminDto admin = RequestTool.getAdmin();
        SystemDto system = SystemInfo.getThisSystemInfo();
        if (!admin.getSystemIdSet().contains(system.getId())) {
            throw new SsoException("\u5c0a\u656c\u7684" + admin.getName() + "\uff0c\u60a8\u6682\u65f6\u6ca1\u6709" + system.getAppName() + "\u7684\u8bbf\u95ee\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u672c\u90e8\u95e8HR\u5f00\u901a");
        }
        if (handler instanceof HandlerMethod && !Objects.equal(null, (Object)(canAccess = (AuthCanAccess)AnnotationUtils.findAnnotation((Method)(method = (HandlerMethod)handler).getMethod(), AuthCanAccess.class)))) {
            return true;
        }
        HttpServletRequest request = RequestTool.getRequest();
        HttpServletResponse response = RequestTool.getResponse();
        String url = request.getRequestURI();
        if (this.adminPowerCacheService.hasPower(admin.getId(), url).booleanValue()) {
            return true;
        }
        if (RequestTool.isAsynchronousRequests().booleanValue()) {
            JSONObject json = new JSONObject();
            json.put("code", (Object)"SSO:01002");
            json.put("success", (Object)false);
            json.put("desc", (Object)"\u60a8\u65e0\u6743\u8bbf\u95ee");
            response.setHeader("Content-Type", "application/json;charset=UTF-8");
            try {
                response.getWriter().write(json.toJSONString());
            }
            catch (IOException e) {
                throw new SsoException((Throwable)e);
            }
        }
        try {
            response.setHeader("Content-Type", "text/html;charset=UTF-8");
            response.getWriter().write("\u65e0\u6743\u8bbf\u95ee");
        }
        catch (IOException e) {
            throw new SsoException((Throwable)e);
        }
        return false;
    }
}

