/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.interceptor.handler;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import java.net.URLEncoder;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class LoginFilterHandler
extends SsoFilterHandler {
    private static Logger logger = LoggerFactory.getLogger(LoginFilterHandler.class);
    @Resource
    private RemoteSSOService remoteSSOService;
    @Resource
    private SsoProperties properties;

    public int getOrder() {
        return -100;
    }

    @Override
    public Boolean before(Object handler) {
        String ticket = RequestTool.findTicket();
        if (StringUtils.isBlank((CharSequence)ticket)) {
            this.returnNotLogin();
            return false;
        }
        try {
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if (admin == null) {
                throw new SsoException("\u901a\u884c\u8bc1\u5931\u6548");
            }
            RequestTool.setAdmin(admin);
            if (RequestTool.getRequestParamMap().containsKey("sso_ticket")) {
                CookieUtil.setCookie("sso_ticket", ticket);
            }
            return true;
        }
        catch (Exception e) {
            logger.info("\u901a\u884c\u8bc1\u9a8c\u8bc1\u5931\u8d25", (Throwable)e);
            this.returnNotLogin();
            return false;
        }
    }

    private void returnNotLogin() {
        try {
            if (RequestTool.isAsynchronousRequests().booleanValue()) {
                RequestTool.getResponse().setHeader("Content-Type", "application/json;charset=UTF-8");
                JSONObject model = new JSONObject();
                model.put("code", (Object)"SSO:01001");
                model.put("success", (Object)false);
                model.put("notLogin", (Object)true);
                RequestTool.getResponse().getWriter().write(model.toJSONString());
            } else {
                HttpServletRequest request = RequestTool.getRequest();
                String redirect = StringUtils.equals((CharSequence)"/", (CharSequence)request.getRequestURI()) ? this.getHomeURL() + this.properties.getDefaultRedirectUrl() : RequestTool.getUrl();
                redirect = URLEncoder.encode(redirect, "utf-8");
                RequestTool.getResponse().sendRedirect(this.getLoginRedirectUrl(redirect));
            }
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    private String getLoginRedirectUrl(String redirect) {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getLoginUrl()).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    private String getHomeURL() {
        String scheme = RequestTool.getRequest().getScheme();
        String serverName = RequestTool.getRequest().getServerName();
        int port = RequestTool.getRequest().getServerPort();
        return scheme + "://" + serverName + ":" + port;
    }

    private String getLoginUrl() {
        return this.properties.getSsoSystemUrl() + "/login";
    }
}

