/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.power;

import cn.com.duiba.sso.api.common.tree.TreeView;
import cn.com.duiba.sso.api.domain.dto.PowerDto;
import cn.com.duiba.sso.api.domain.event.SsoSystemInitSuccessEvent;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemotePermissionService;
import cn.com.duiba.sso.api.service.eventbus.BizEventListener;
import cn.com.duiba.sso.api.service.power.PowerTreeService;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.power.PowerCache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.eventbus.Subscribe;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@BizEventListener
public class AdminPowerCacheService {
    private static Logger logger = LoggerFactory.getLogger(AdminPowerCacheService.class);
    private LoadingCache<Long, PowerCache> adminPowerCache = CacheBuilder.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).build((CacheLoader)new AdminRoleCacheLoader());
    @Autowired
    private RemotePermissionService remotePermissionService;
    @Autowired
    private PowerTreeService powerTreeService;
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    @Subscribe
    public void SystemInfoInitComplateEventListener(SsoSystemInitSuccessEvent event) {
        this.executorService.scheduleWithFixedDelay(new AdminPowerFlushTask(), 30L, 30L, TimeUnit.SECONDS);
    }

    private PowerCache getPowerCache(Long adminId) {
        try {
            return (PowerCache)this.adminPowerCache.get((Object)adminId);
        }
        catch (Exception e) {
            throw new SsoRunTimeException((Throwable)e);
        }
    }

    public Boolean hasPower(Long adminId, String url) {
        Set pawerIds = this.powerTreeService.getPowerIdsByUrl(url);
        if (pawerIds.isEmpty()) {
            return true;
        }
        PowerCache cache = this.getPowerCache(adminId);
        return !Sets.intersection((Set)pawerIds, cache.getPowerIdSet()).isEmpty();
    }

    public <T extends TreeView<T>> List<T> powerForAdmin(Long adminId, Function<PowerDto, T> transform) {
        PowerCache cache = this.getPowerCache(adminId);
        return this.powerTreeService.getPowerTree(cache.getPowerIdSet(), transform);
    }

    public Set<String> getAllPowerRes(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        Set<Long> powerIds = cache.getPowerIdSet();
        HashSet urlSet = Sets.newHashSet();
        for (Long id : powerIds) {
            PowerDto power = this.powerTreeService.getPower(id);
            if (power == null) continue;
            urlSet.addAll(power.getUrls());
        }
        return urlSet;
    }

    public Long version(Long adminId) {
        PowerCache cache = this.getPowerCache(adminId);
        return cache.getVersion();
    }

    public void clean(Long adminId) {
        this.adminPowerCache.invalidate((Object)adminId);
    }

    private class AdminPowerFlushTask
    implements Runnable {
        private AdminPowerFlushTask() {
        }

        @Override
        public void run() {
            try {
                Long systemId = SystemInfo.getThisSystemId();
                Set adminIds = AdminPowerCacheService.this.adminPowerCache.asMap().keySet();
                for (Long adminId : adminIds) {
                    PowerCache cache = (PowerCache)AdminPowerCacheService.this.adminPowerCache.getIfPresent((Object)adminId);
                    if (cache == null) {
                        return;
                    }
                    Long version = AdminPowerCacheService.this.remotePermissionService.getAdminPowerVersion(systemId, adminId);
                    if (cache.getVersion() >= version) {
                        return;
                    }
                    AdminPowerCacheService.this.adminPowerCache.invalidate((Object)adminId);
                }
            }
            catch (Exception e) {
                logger.error("\u7ba1\u7406\u5458\u6743\u9650\u68c0\u6d4b\u5931\u8d25", (Throwable)e);
            }
        }
    }

    private class AdminRoleCacheLoader
    extends CacheLoader<Long, PowerCache> {
        private AdminRoleCacheLoader() {
        }

        public PowerCache load(Long adminId) {
            Long systemId = SystemInfo.getThisSystemId();
            Set powerIds = AdminPowerCacheService.this.remotePermissionService.getPowerIdsBySystemIdAndAdminId(systemId, adminId);
            PowerCache cache = new PowerCache(AdminPowerCacheService.this.remotePermissionService.getAdminPowerVersion(systemId, adminId));
            cache.setPowerIdSet(powerIds);
            return cache;
        }
    }
}

