/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.websocket;

import cn.com.duiba.sso.api.web.websocket.AbstractWebSocketAction;
import cn.com.duiba.sso.api.web.websocket.domain.SsoWebSocketMessage;
import com.google.common.collect.Maps;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

@Service
public class SsoWebSocketService
implements ApplicationContextAware {
    private Map<String, AbstractWebSocketAction<? super SsoWebSocketMessage>> ACTION_MAP = Maps.newConcurrentMap();

    public AbstractWebSocketAction<? super SsoWebSocketMessage> getAction(String actionName) {
        return this.ACTION_MAP.get(actionName);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beans = applicationContext.getBeansOfType(AbstractWebSocketAction.class);
        for (AbstractWebSocketAction action : beans.values()) {
            this.ACTION_MAP.put(action.getActionPath(), action);
        }
    }
}

