/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.sso.api.web.websocket;

import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.JsonRender;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.power.AdminPowerCacheService;
import cn.com.duiba.sso.api.web.websocket.AbstractWebSocketAction;
import cn.com.duiba.sso.api.web.websocket.SsoWebSocketService;
import cn.com.duiba.sso.api.web.websocket.domain.ErrorResponse;
import cn.com.duiba.sso.api.web.websocket.domain.SsoWebSocketMessage;
import cn.com.duiba.sso.api.web.websocket.domain.SsoWebSocketMetadata;
import cn.com.duiba.sso.api.web.websocket.domain.SsoWebSocketResponse;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/{stamp}")
@Component
public class SsoWebSocketSession {
    private static final String WEB_SOCKET_ACTION = "actionName";
    private static AtomicInteger onlineCount = new AtomicInteger(0);
    private static Map<Long, SsoWebSocketSession> SESSION_MAP = Maps.newConcurrentMap();
    @Autowired
    private RemoteSSOService remoteSSOService;
    @Autowired
    private SsoWebSocketService ssoWebSocketService;
    @Autowired
    private AdminPowerCacheService adminPowerCacheService;
    private Session session;
    private Long adminId;

    public static Set<SsoWebSocketSession> getAdminSocketSession(Set<Long> adminIds) {
        Objects.requireNonNull(adminIds);
        HashSet set = Sets.newHashSet();
        for (Long adminId : adminIds) {
            if (!SESSION_MAP.containsKey(adminId)) continue;
            set.add(SESSION_MAP.get(adminId));
        }
        return set;
    }

    @OnOpen
    public void onOpen(@PathParam(value="stamp") Long stamp, Session session) throws IOException {
        try {
            String ticket = this.remoteSSOService.findTicketByStamp(SystemInfo.getThisSystemId(), stamp);
            if (StringUtils.isBlank((String)ticket)) {
                throw new SsoException("\u51ed\u8bc1\u5931\u6548");
            }
            AdminDto admin = this.remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if (admin == null) {
                throw new SsoException("\u901a\u884c\u8bc1\u5931\u6548");
            }
            this.adminId = admin.getId();
            this.session = session;
            SESSION_MAP.put(this.adminId, this);
            onlineCount.incrementAndGet();
            JsonRender jsonRender = JsonRender.successResult();
            jsonRender.put("id", this.adminId);
            jsonRender.put("name", admin.getName());
            jsonRender.put("info", "WebSocket\u8fde\u63a5\u6210\u529f");
            this.sendMessage(jsonRender);
        }
        catch (Exception e) {
            this.sendMessage(JsonRender.failResult(e));
            session.close();
        }
    }

    public void sendMessage(JSONObject message) throws IOException {
        this.session.getBasicRemote().sendText(message.toJSONString());
    }

    public void sendMessage(SsoWebSocketResponse message) throws IOException {
        this.session.getBasicRemote().sendText(JSONObject.toJSONString((Object)message));
    }

    @OnMessage
    public void onMessage(String message, Session session) throws IOException {
        try {
            JSONObject messageJson = JSONObject.parseObject((String)message);
            if (!messageJson.containsKey((Object)WEB_SOCKET_ACTION)) {
                throw new SsoException("\u6ca1\u6709\u6307\u5b9a\u6d88\u606f\u5904\u7406\u5668\u7684\u540d\u79f0");
            }
            String actionName = messageJson.getString(WEB_SOCKET_ACTION);
            if (!this.adminPowerCacheService.hasPower(this.adminId, actionName).booleanValue()) {
                throw new SsoException("\u65e0\u6743\u63d0\u4ea4");
            }
            AbstractWebSocketAction<? super SsoWebSocketMessage> action = this.ssoWebSocketService.getAction(actionName);
            Class rawType = (Class)((ParameterizedType)action.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
            SsoWebSocketMetadata metadata = new SsoWebSocketMetadata();
            metadata.setAdminId(this.adminId);
            Object messageParams = messageJson.toJavaObject(rawType);
            BeanUtils.setProperty((Object)messageParams, (String)"ssoWebSocketMetadata", (Object)metadata);
            action.getClass().getMethod("messageListener", rawType).invoke(action, messageParams);
        }
        catch (Exception e) {
            this.sendMessage(new ErrorResponse(e));
        }
    }
}

