/*
 * Decompiled with CFR 0.152.
 */
package sso.spring.config;

import cn.com.duiba.sso.api.SsoBasicConfiguration;
import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerMateInfoAdapter;
import cn.com.duiba.sso.api.service.logger.service.SsoLoggerService;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.web.interceptor.SsoInterceptor;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.socket.server.standard.ServerEndpointExporter;

@Configuration
@EnableWebSecurity
@ComponentScan(value={"cn.com.duiba.sso.api.web"})
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={SsoProperties.class})
@Import(value={SsoBasicConfiguration.class, SsoInterceptor.class})
public class SsoAutoConfiguration
extends WebMvcConfigurerAdapter {
    @Resource
    private SsoInterceptor ssoInterceptor;
    @Resource
    private SsoProperties ssoProperties;
    @Resource
    private SsoLoggerService ssoLoggerService;
    @Resource
    private SsoLoggerMateInfoAdapter ssoLoggerMateInfoAdapter;

    public void addInterceptors(InterceptorRegistry registry) {
        String pathPatterns = this.ssoProperties.getPathPatterns();
        String excludePathPatterns = this.ssoProperties.getExcludePathPatterns();
        String[] paths = StringUtils.split((String)pathPatterns, (String)",");
        String[] excludePath = StringUtils.isEmpty((String)excludePathPatterns) ? new String[]{} : StringUtils.split((String)excludePathPatterns, (String)",");
        registry.addInterceptor((HandlerInterceptor)this.ssoInterceptor).addPathPatterns(paths).addPathPatterns(new String[]{"/auth/**"}).excludePathPatterns(excludePath);
        super.addInterceptors(registry);
        this.ssoLoggerService.setSsoLoggerMateInfoAdapter(this.ssoLoggerMateInfoAdapter);
    }

    @Bean
    public ServerEndpointExporter serverEndpointExporter() {
        return new ServerEndpointExporter();
    }

    @Bean
    public RequestTool initRequestTool() {
        return new RequestTool();
    }
}

