package cn.com.duiba.sso.api.web.interceptor.handler.impl;

import cn.com.duiba.sso.api.constants.SsoProperties;
import cn.com.duiba.sso.api.domain.dto.AdminDto;
import cn.com.duiba.sso.api.exception.SsoException;
import cn.com.duiba.sso.api.exception.SsoRunTimeException;
import cn.com.duiba.sso.api.remoteservice.RemoteSSOService;
import cn.com.duiba.sso.api.tool.CookieUtil;
import cn.com.duiba.sso.api.tool.RequestTool;
import cn.com.duiba.sso.api.tool.SystemInfo;
import cn.com.duiba.sso.api.web.interceptor.annotation.OnlyMobileHandler;
import cn.com.duiba.sso.api.web.interceptor.handler.SsoFilterHandler;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.net.URLEncoder;

@OnlyMobileHandler
@Component
public class MobileLoginFilterHandler extends AbstractLoginFilterHandler {

    private static Logger logger = LoggerFactory.getLogger(MobileLoginFilterHandler.class);

    @Resource
    protected SsoProperties properties;
    @Resource
    private RemoteSSOService remoteSSOService;

    @Override
    public Boolean before(Object handler){
        String ticket = RequestTool.findMobileTicket();
        if(StringUtils.isBlank(ticket)){
            returnNotLogin();
            return false;
        }
        try{
            AdminDto admin = remoteSSOService.verifyTicketAndGetAdmin(ticket);
            if(admin==null){
                throw new SsoException("通行证失效");
            }
            //注入adminId
            RequestTool.setAdmin(admin);
            return true;
        }catch (Exception e){
            logger.info("通行证验证失败",e);
            returnNotLogin();
            return false;
        }
    }

    /**
     * 获取登录重定向地址
     * @param redirect
     * @return
     */
    @Override
    protected String getLoginRedirectUrl(String redirect){
        StringBuilder builder = new StringBuilder();
        String loginUrl = properties.getSsoSystemUrl() + "/mobile/emailBind";
        builder.append(loginUrl).append("?redirect=").append(redirect);
        builder.append("&systemId=").append(SystemInfo.getThisSystemId());
        return builder.toString();
    }

    @Override
    protected String getDefaultRedirectUrl(){
        return properties.getMobileDefaultRedirectUrl();
    }



}
